TOOL.Category = "Construction"
TOOL.Name = "#NPC Alignment Switcher Tool"
TOOL.Command = nil
TOOL.ConfigName = ""

-- ConVars

TOOL.ClientConVar["Type"] = "Rebel"

-- Client

if (CLIENT) then
	language.Add("Tool_alignment_name", "NPC Alignment Switcher Tool")
	language.Add("Tool_alignment_desc", "Allows you to change the alignment (Team) of an npc.")
	language.Add("Tool_alignment_0", "Left click on an npc to change it's alignment.")
end

-- Message

function TOOL:Message(Text)
	if SERVER then
		self:GetOwner():SendLua("GAMEMODE:AddNotify('"..Text.."', NOTIFY_GENERIC, 10)")
		self:GetOwner():SendLua("surface.PlaySound('ambient/water/drip"..math.random(1, 4)..".wav')")
	end
end

-- Left click

function TOOL:LeftClick(Trace)
	if Trace.Entity then
		if !Trace.Entity:IsValid() or !Trace.Entity:IsNPC() then
			return false
		end
	end

	if(CLIENT) then
		return true
	end

	if(!SERVER) then return false end

	local Type = self:GetClientInfo("Type")
	local npc = Trace.Entity

	if Type == "Citizen" then
		npc:SetName( "fake_citizen" )
		CreateAlignments( "npc_antlion", npc:GetName(), "dislike" )
		CreateAlignments( "npc_citizen", npc:GetName(), "like" )
		CreateAlignments( "npc_combine", npc:GetName(), "dislike" )
		CreateAlignments( "npc_zombie", npc:GetName(), "dislike" )
		npc:Fire("setrelationship", "player d_li 97", 0)
		npc:Fire("setrelationship", "npc_antlion d_ht 99", 0)
		npc:Fire("setrelationship", "npc_citizen d_li 97", 0)
		npc:Fire("setrelationship", "npc_combine d_ht 99", 0)
		npc:Fire("setrelationship", "npc_zombie d_ht 98", 0)

	elseif Type == "Combine" then
		npc:SetName( "fake_combine" )
		CreateAlignments( "npc_antlion", npc:GetName(), "dislike" )
		CreateAlignments( "npc_citizen", npc:GetName(), "like" )
		CreateAlignments( "npc_combine", npc:GetName(), "dislike" )
		CreateAlignments( "npc_zombie", npc:GetName(), "dislike" )
		npc:Fire("setrelationship", "player d_ht 99", 0)
		npc:Fire("setrelationship", "npc_antlion d_ht 99", 0)
		npc:Fire("setrelationship", "npc_citizen d_ht 99", 0)
		npc:Fire("setrelationship", "npc_combine d_li 97", 0)
		npc:Fire("setrelationship", "npc_zombie d_ht 98", 0)

	elseif Type == "Zombie" then
		npc:SetName( "fake_zombie" )
		CreateAlignments( "npc_antlion", npc:GetName(), "dislike" )
		CreateAlignments( "npc_citizen", npc:GetName(), "dislike" )
		CreateAlignments( "npc_combine", npc:GetName(), "dislike" )
		CreateAlignments( "npc_zombie", npc:GetName(), "like" )
		npc:Fire("setrelationship", "player d_ht 98", 0)
		npc:Fire("setrelationship", "npc_antlion d_ht 99", 0)
		npc:Fire("setrelationship", "npc_citizen d_ht 98", 0)
		npc:Fire("setrelationship", "npc_combine d_ht 99", 0)
		npc:Fire("setrelationship", "npc_zombie d_li 97", 0)

	elseif Type == "Antlion" then
		npc:SetName( "fake_antlion" )
		CreateAlignments( "npc_antlion", npc:GetName(), "like" )
		CreateAlignments( "npc_citizen", npc:GetName(), "dislike" )
		CreateAlignments( "npc_combine", npc:GetName(), "dislike" )
		CreateAlignments( "npc_zombie", npc:GetName(), "dislike" )
		npc:Fire("setrelationship", "player d_ht 98", 0)
		npc:Fire("setrelationship", "npc_antlion d_li 97", 0)
		npc:Fire("setrelationship", "npc_citizen d_ht 98", 0)
		npc:Fire("setrelationship", "npc_combine d_ht 99", 0)
		npc:Fire("setrelationship", "npc_zombie d_ht 99", 0)

	else
		self:Message("NPC's alignment was invalid")
		return false
	end

	self:Message("NPC's alignment switched to "..Type.."!")
	return true
end

function CreateAlignments( class, npc, alignment )
	local foundents = ents.FindInSphere(Vector(0, 0, 0),100000000000)
	for k,v in pairs(foundents) do
		if v:IsNPC() then
			if v:GetClass() == class then
				if alignment == "like" then
					v:Fire("setrelationship", npc.." d_li 97", 0)
				elseif alignment == "dislike" then
					v:Fire("setrelationship", npc.." d_ht 99", 0)
				else
					Msg( "Alignment unrecognised.\n" )
				end
			end
		end
	end
end

-- Build CPanel

function TOOL.BuildCPanel(Panel)
	Panel:AddControl("Header", {Text = "#Tool_alignment_name", Description	= "#Tool_alignment_desc"})

	local Options = { }

	local Types = {
		"Antlion",
		"Citizen",
		"Combine",
		"Zombie"
	}

	for K, V in pairs(Types) do
		Options[V] = {alignment_Type = V}
	end

	Panel:AddControl("ListBox", {Label = "#Choose alignment", MenuButton = 0, Height = 120, Options = Options})
end 